/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure.structure_repair;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.structure.BMDStructures;
import com.cerbon.bosses_of_mass_destruction.structure.structure_repair.StructureRepair;
import com.cerbon.cerbons_api.api.static_utilities.ParticleUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class LichStructureRepair
implements StructureRepair {
    @Override
    public ResourceKey<Structure> associatedStructure() {
        return BMDStructures.LICH_STRUCTURE_REGISTRY.getConfiguredStructureKey();
    }

    @Override
    public void repairStructure(ServerLevel level, StructureStart structureStart) {
        BlockPos pos = this.altarCenter(level, structureStart);
        BlockState altar = ((Block)BMDBlocks.CHISELED_STONE_ALTAR.get()).defaultBlockState();
        List<BlockPos> positions = List.of(pos.west(6), pos.east(6), pos.north(6), pos.south(6));
        for (BlockPos altarPos : positions) {
            level.setBlockAndUpdate(altarPos, altar);
            ParticleUtils.spawnParticle((ServerLevel)level, (ParticleOptions)((ParticleOptions)BMDParticles.SOUL_FLAME.get()), (Vec3)VecUtils.asVec3((BlockPos)altarPos).add(0.5, 1.0, 0.5), (Vec3)VecUtils.unit, (int)10, (double)0.0);
        }
    }

    @Override
    public boolean shouldRepairStructure(ServerLevel level, StructureStart structureStart) {
        BlockPos pos = this.altarCenter(level, structureStart);
        boolean hasAltar = level.getBlockState(pos.west(6)).getBlock() == BMDBlocks.CHISELED_STONE_ALTAR.get();
        boolean noBoss = level.getEntities((EntityTypeTest)BMDEntities.LICH.get(), lichEntity -> lichEntity.distanceToSqr(VecUtils.asVec3((BlockPos)pos)) < 10000.0).isEmpty();
        return !hasAltar && noBoss;
    }

    private BlockPos altarCenter(ServerLevel level, StructureStart structureStart) {
        BoundingBox boundingBox = structureStart.getBoundingBox();
        int yPos = boundingBox.getCenter().below(16).getY();
        int centerX = boundingBox.getCenter().getX();
        int centerZ = boundingBox.getCenter().getZ();
        Optional<Pair> gridPos = IntStream.rangeClosed(-2, 2).boxed().flatMap(x -> IntStream.rangeClosed(-2, 2).mapToObj(z -> new Pair((Object)(x + centerX), (Object)(z + centerZ)))).max(Comparator.comparingInt(xzPair -> this.countChestsInColumn(boundingBox, level, (Pair<Integer, Integer>)xzPair)));
        return gridPos.map(xzPair -> new BlockPos(((Integer)xzPair.getFirst()).intValue(), yPos, ((Integer)xzPair.getSecond()).intValue())).orElse(null);
    }

    private int countChestsInColumn(BoundingBox boundingBox, ServerLevel level, Pair<Integer, Integer> xzPair) {
        return (int)IntStream.rangeClosed(boundingBox.minY(), boundingBox.maxY()).filter(y -> level.getBlockState(new BlockPos(((Integer)xzPair.getFirst()).intValue(), y, ((Integer)xzPair.getSecond()).intValue())).getBlock() == Blocks.CHEST).count();
    }
}

